clear


* NOTES
* =====

* To run this, first download fiscal year ends for all firm-years in Compustat. Call the file compustat_fiscalyearends
* Then download all execucomp data. Call the file execucomp_allvars
* Then run the code below.
* Then run the parts in the file process_saez_brookings.do which pertains to Table 4.


* CODE FOR PROCESSING DATA
* ========================

use compustat_fiscalyearends
keep gvkey fyear fyr
rename fyear year
so gvkey year
save compustat_fiscalyearends1, replace

use execucomp_allvars
so gvkey year
mer gvkey year using compustat_fiscalyearends1
drop if _m==2
drop if _m==1

tab fyr, missing
keep if fyr==12


* Restrict sample to observations for which all subcomponents of tdc1 and tdc2 are defined

* Define x1, equals tdc1 
ge x1=salary+bonus+othann+rstkgrnt+ltip+allothtot+option_awards_blk_value
ge x12006on=salary+bonus+noneq_incent+option_awards_fv+stock_awards_fv+defer_rpt_as_comp_tot+othcomp
replace x1=x12006on if x1==.
su tdc1 x1 if tdc1~=. & x1~=.

* Define x2, equals tdc2
ge x2=salary+bonus+othann+rstkgrnt+ltip+allothtot+opt_exer_val
ge x22006on=salary+bonus+noneq_incent+opt_exer_val+stock_awards_fv+defer_rpt_as_comp_tot+othcomp
replace x2=x22006on if x2==.
su tdc2 x2 if tdc2~=. & x2~=.

ge xsalary=salary
ge xbonus=bonus
ge xstock=rstkgrnt
replace xstock=stock_awards_fv if rstkgrnt==.
ge xoptions1=option_awards_blk_value
replace xoptions1=option_awards_fv if xoptions1==.
ge xoptions2=opt_exer_val
ge xother=othann+ltip+allothtot
replace xother=noneq_incent+defer_rpt_as_comp_tot+othcomp if xother==.

keep if x1~=. & x2~=.

for any xsalary xbonus xstock xoptions1 xother xoptions2 tdc1 tdc2: egen sX=mean(X), by(year)
so year
drop if year==year[_n-1]
so year
ge ok1=sxsalary+sxbonus+sxstock+sxoptions1+sxother
ge ok2=sxsalary+sxbonus+sxstock+sxoptions2+sxother
keep year sxsalary sxbonus sxstock sxoptions1 sxother sxoptions2 stdc1 stdc2 ok1 ok2
save execucomp1_allvars, replace


* TABLE 4
* =======

clear 
use saezdata, replace
ge lngyex0100=ln(yex0100/yex0100[_n-1])
so year
mer year using execucomp1_allvars
drop _m
so year

ge stdc1ex=stdc1-sxoptions1
ge stdc2ex=stdc2-sxoptions2
for any sxsalary sxbonus sxstock sxoptions1 sxother sxoptions2 stdc1 stdc2 stdc1ex stdc2ex: ge X_real=X*inflfactor
for any sxsalary sxbonus sxstock sxoptions1 sxother sxoptions2 stdc1 stdc2 stdc1ex stdc2ex: ge lngX=ln(X_real/X_real[_n-1])

for any sxsalary sxbonus sxstock sxoptions1 sxother: ge r1X=X/stdc1

su stdc1_real stdc2_real if year==1992
su stdc1_real stdc2_real if year==2009

su r1* if year==1992
su r1* if year==2009

eststo clear
eststo: reg lngstdc1 lngyex0100 if year~=2006
eststo: reg lngsxsalary lngyex0100 if year~=2006
eststo: reg lngsxbonus lngyex0100 if year~=2006
eststo: reg lngsxstock lngyex0100 if year~=2006
eststo: reg lngsxoptions1 lngyex0100 if year~=2006
eststo: reg lngsxother lngyex0100 if year~=2006
eststo: reg lngstdc2 lngyex0100 if year~=2006
eststo: reg lngsxoptions2 lngyex0100 if year~=2006
esttab, se nostar b(2)

reg lngstdc1ex lngyex0100 if year~=2006

for any sxsalary sxbonus sxstock sxoptions1 sxother sxoptions2 stdc1 stdc2 : ge gX=(X_real/X_real[_n-1])-1
su gstdc1 gstdc2 if year==2008
su gstdc1 gstdc2 if year==2009

